// IAccountManager.java
// Version 0.41
// Last Updated: 10/17/2000

// Change Log
// RP101600 - Standardize naming, tab spacing, and commenting.
// RP101600 - Rearranged order of methods to correspond to Object Model (for ease of reading)

package Alkindi.BusinessServices;

import Alkindi.BusinessDataTypes.*;

public interface IAccountManager { 
	boolean createMember(SystemUser systemUser, AccountInfo accountInfo) throws AlkExcept;
	SystemUser createUser() throws AlkExcept;
	AccountInfo getAccountInfo(SystemUser su) throws AlkExcept;
	int[] getQuestions(String login) throws AlkExcept;
	boolean isScreenNameDuplicate(String name) throws AlkExcept;
	boolean updateMember(SystemUser systemUser, AccountInfo accountInfo) throws AlkExcept;
	boolean updateUserStatus(SystemUser systemUser, int Status) throws AlkExcept;
	SystemUser validateUser(String login, String password) throws AlkExcept;
	SystemUser validateUserQuestions(String login, int q1, String a1, int q2, String a2) throws AlkExcept;
	String getForgottenPass(SystemUser systemUser) throws AlkExcept;
	boolean updatePassword(SystemUser systemUser, String password_old, String password_new) throws AlkExcept;
}
